package com.qboxus.tictic.repositories

import androidx.lifecycle.MutableLiveData
import com.google.gson.Gson
import com.qboxus.tictic.Constants
import com.qboxus.tictic.activitesfragments.shoping.models.ProductModel
import com.qboxus.tictic.activitesfragments.spaces.models.HomeUserModel
import com.qboxus.tictic.activitesfragments.spaces.models.RoomModel
import com.qboxus.tictic.activitesfragments.spaces.models.TopicModel
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.models.PrivacySettingModel
import com.qboxus.tictic.models.PushNotificationModel
import com.qboxus.tictic.models.SoundsModel
import com.qboxus.tictic.models.StoryModel
import com.qboxus.tictic.models.UserModel
import com.qboxus.tictic.simpleclasses.DataParsing
import com.qboxus.tictic.simpleclasses.DataParsing.getTopicDataModel
import com.qboxus.tictic.simpleclasses.DataParsing.getUserDataModel
import com.qboxus.tictic.simpleclasses.DataParsing.getVideoDataModel
import com.qboxus.tictic.simpleclasses.Functions
import org.json.JSONArray
import org.json.JSONObject

class RoomRepository : BaseRepository<UserModel>() {

    suspend fun getRoomList(
        params: JSONObject,
        liveData: MutableLiveData<ApiResponce<ArrayList<RoomModel>>>,
    ) {

        try {

        val endpoint = { requestBody: String ->
            apiInterface.showRooms(requestBody)
        }
        val parseData = { apiResponseData: ApiResponseData ->
            when (apiResponseData) {
                is ApiResponseData.JsonArray -> {
                    val list = ArrayList<RoomModel>()
                    for (i in 0 until apiResponseData.data.length()) {
                        val `object` = apiResponseData.data.optJSONObject(i)

                        val roomObj = `object`.optJSONObject("Room")
                        val topicobject = `object`.optJSONObject("Topic")
                        val roomMemberArray = `object`.optJSONArray("RoomMember")

                        val model = RoomModel()
                        model.id = roomObj.optString("id")
                        model.adminId = roomObj.optString("user_id")
                        model.title = roomObj.optString("title")
                        model.privacyType = roomObj.optString("privacy")

                        val topicList = java.util.ArrayList<TopicModel>()
                        val topicModel = getTopicDataModel(topicobject)
                        topicList.add(topicModel)
                        model.topicModels = topicList

                        val userList = java.util.ArrayList<HomeUserModel>()
                        for (j in 0 until roomMemberArray.length()) {
                            val innerObj = roomMemberArray.getJSONObject(j)
                            val userModel = getUserDataModel(innerObj.optJSONObject("User"))

                            val userItemModel = HomeUserModel()
                            userItemModel.userModel = userModel
                            userItemModel.userRoleType = innerObj.optString("moderator")
                            userList.add(userItemModel)
                        }
                        model.userList = userList

                        list.add(model)
                    }
                    list
                }

                else -> throw IllegalArgumentException("Unsupported response type")
            }
        }

        makeApiCall(params, endpoint, liveData, parseData)

        }catch (e:Exception){}
    }

}